function evaluate_CCRF_grad_desc_audio(lambda_as, lambda_bs, useCA_CCRF, resultsLoc)
    % Evaluating the CCRF model with given regularisation parameters

    addpath('../lib/');

    % add data preparation helper functions
    addpath('../data preparation/');

    svrPredFolder = '../data/svrPreds/'; 

    dimLabels = {'valence','arousal','power','expectancy'};

    resultsCorr = zeros(4, 1);
    resultsRMSE = zeros(4, 1);

    for dim=1:4

        fprintf('\n-----------------------------\n');
        fprintf('Training the model \n------------------------------\n');

        % prepare the training data (yTrain is normalised version, yTest is
        % unnormalised, xLocal, corresponds to the unnormalised x values used for
        % calculating offsets, as CA-CCRF might be used here need to calculate
        % offsets locally

        % for this sampe we only train valence
        % we are using the second training set (as SVRs were trained on train1)
        if(useCA_CCRF)
            [xNormed, xOffsets, yNormed, yUnnormed] = prepareMultiData(dim, dimLabels, svrPredFolder, {'/train2_'});
        else
            [xNormed, xOffsets, yNormed, yUnnormed] = prepareSingleData([svrPredFolder '/train2_' dimLabels{dim} '.mat']);
        end
        
        % pick only audio predictions
        for i=1:numel(xNormed)
            xNormed{i} =  xNormed{i}(:,[3]);
        end

        nExamples = numel(yNormed);
        nFeatures = size(xNormed{1},2);

        lambda_a = lambda_as(dim);
        lambda_b = lambda_bs(dim); 

        % number of similarity functions
        nGaussians = 5;
        nNeighbor = 5;

        % this will create a family of exponential decays with different sigmas
        similarities = {};

        range = 1:nFeatures; % all features used for the exponential similarity
        for i=1:nGaussians
            sigma = 2.0^(-i-5);
            exponentialDecay = @(x, m) similarityGauss(x, sigma, range, m);
            similarities = [similarities; {exponentialDecay}];
        end

        for i=1:nNeighbor
            neigh = i;
            neighFn = @(x, m) similarityNeighbor(x, neigh, range, m);
            similarities = [similarities; {neighFn}];
        end

        %initialize the parameter estimates, values don't matter much as the
        %problem is convex (as long as they are positive)
        alphas = ones(nFeatures,1);
        beta = ones(numel(similarities), 1);

        % we don't use indicators in this version as they don't seem to help
        useIndicators = 0;
        masks = cell(numel(yNormed),1);        
        % we train on normalised data
        
        nIterations =  600;
        learningRate = 0.0000075; 
        threshold = 1e-4;
        
        tic 
        [alphasCCRF, betaCCRF, scaling] = CCRF_training_gradient_descent(nIterations, nExamples, learningRate, threshold, xNormed, yNormed, yUnnormed, masks, alphas, beta, lambda_a, lambda_b, similarities, useIndicators, true);
%         [alphasCCRF, betaCCRF, scaling] = CCRF_training_grad_desc(nExamples, thresholdX, thresholdFun, xNormed, yNormed, yUnnormed, masks, alphas, beta, lambda_a, lambda_b, similarities, useIndicators);
        fprintf('betas: min: %.4f, med: %.4f, max: %.4f\n', min(betaCCRF), median(betaCCRF), max(betaCCRF));
        fprintf('alphas: '); fprintf('%.4f\t', alphasCCRF');
        alpha_prop = (alphasCCRF'*ones(nFeatures,1)) \ alphasCCRF;   
        fprintf('\nalpha proportions: ');fprintf('%.4f\t', alpha_prop'); fprintf('\n');
        toc;

        %--- Evaluation on training partition
        [corrsTrain, rmssTrain, meanCorrTrain, meanRMSTrain] = evaluateCCRFmodel(alphasCCRF, betaCCRF, xNormed, xOffsets, yUnnormed, masks, useIndicators, similarities, scaling, true);
        fprintf('Corr on training: %.3f, rmse: %.3f\n', meanCorrTrain, meanRMSTrain);

        if(useCA_CCRF)
            [xNormed, xOffsets, yNormed, yUnnormed] = prepareMultiData(dim, dimLabels, svrPredFolder, {'/test_'});
        else
            [xNormed, xOffsets, yNormed, yUnnormed] = prepareSingleData([svrPredFolder '/test_' dimLabels{dim} '.mat']);            
        end
        % pick only video predictions
        for i=1:numel(xNormed)
            xNormed{i} =  xNormed{i}(:,[3]);
        end
        
        %--- Evaluation on test partition
        [corrsTest, rmssTest, meanCorrTest, meanRMSTest] = evaluateCCRFmodel(alphasCCRF, betaCCRF, xNormed, xOffsets, yUnnormed, masks, useIndicators, similarities, scaling, true);
        fprintf('Corr on test: %.3f, rmse: %.3f \n', meanCorrTest, meanRMSTest);       
        resultsCorr(dim) = meanCorrTest;
        resultsRMSE(dim) = meanRMSTest;
    end
    save(resultsLoc, 'resultsCorr', 'resultsRMSE');
end